
#ifndef _1_SST_TST_DEFINES_h_H
#define _1_SST_TST_DEFINES_h_H
#include "DX_VOS_BaseTypes.h"

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_DEFINES.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.

   *           All Rights reserved
   */

/************************ Defines *****************************************/
/* Define if to use Full test - this should be Set to 0 when external ATP*/
/*-----------------------------------------------------------------------*/
/*Should be defined - If not defined tests will not stop on error*/
#define SST_TST_EXIT_ON_ERROR 1
#define SST_HALT_ON_ERROR     1

/*Disable/Enable test modules for limited memory platforms*/
/*--------------------------------------------------------*/
#define TST_USE_SPECIAL_DATA_MODULE     1
#define TST_USE_DATA_MODULE             1
#define TST_USE_AUTHENTICATOR_MODULE    1
#define TST_USE_INDEX_MODULE            1
#define TST_USE_ITERTOR_MODULE          1
#define TST_USE_ROLL_BACK_MODULE        1 /*If this is selected - TST_USE_ITERTOR_MODULE must be set to 1 */
#define TST_USE_INIT_TERMINATE_MODULE   1
#define TST_USE_CRYS_SST_SYM_MODULE     1
#define TST_USE_CRYS_SST_ASYM_MODULE    1
#define TST_USE_SST_MM_MODULE           1
#define TST_USE_SST_UTIL_MODULE         1
/* AES key size for TST_USE_SST_KMNG_SYM_MODULE */
#define TST_SST_USE_AES_192_KEY       0
#define TST_SST_USE_AES_256_KEY       0

/*In case of system memory under 128KB*/
#define TST_LIMITED_MEMORY_PLATFROM 0 /* 1 Dissables large data vectors from tests*/
                                      /* Will effect Data and Special data vectors only!*/


/* Print levels */
/*--------------*/
#define SST_TST_MSG 		10
#define SST_TST_DBG_HIGH 	20
#define SST_TST_DBG_MED		30
#define SST_TST_DBG_LOW 	40

/* Define for external tests locations*/
/*------------------------------------*/
#define SST_TST_FILE_PATH_LENGTH 500


/*Defines for test log file */
/*--------------------------*/
#define SST_TST_PRINT_TO_LOG_FILE 1
#define SST_TST_RESULT_LOG "SST_TST_LOG.log"
#define SST_DB_FILENAME "TST_DX_SST6_DB"
#define SST_DB_FILENAME_SIZE_BYTES  14
#define SST_DB_FILENAME_SECOND "TST_DX_SST6_DB_SECOND"

/* General */
/*---------*/
#define TESTPASS 	                     0
#define TESTFAIL 	                     1
#define TST_TRUE                         1
#define TST_FALSE                        0
#define TST_ZERO                         0
#define TST_WORKSPACE_SIZE_BYTES         13000
#define TST_NAME_STRING_LEN              70
#define NO_AUTHENTICATOR                 0
#define TST_WRONG_KEY_TYPE               1000
#define TST_WRONG_AUTH_FLAG              1000
#define TST_END_TEST                     -100
#define TST_INTERNAL_HANDLE              0
#define TST_TEST_DEFINED_HENDLE          1
#define TST_TEST_DEFINED_HENDLE_1        11
#define TST_TEST_DEFINED_HENDLE_2        22
#define TST_TEST_DEFINED_HENDLE_3        33
#define TST_TEST_DEFINED_HENDLE_4        44
#define TST_TEST_DEFINED_HENDLE_5        55
#define TST_TEST_DEFINED_HENDLE_6        66
#define TST_TEST_DEFINED_HENDLE_7        77
#define TST_TEST_DEFINED_HENDLE_8        88
#define TST_TEST_DEFINED_HENDLE_9        99
#define TST_HANDLES_TYPES                2
#define TST_TEMP_DATA_LENGTH             500
#define TST_MAX_NUMBERS_OF_HANDLES_2READ 10
#define TST_HANDLES_NO_OFFSET            0
#define TST_ONE_HANDLE                   1
#define TST_4_HANDLES                    4
#define TST_3_HANDLES                    3
#define TST_2_HANDLES                    2
#define TST_1_HANDLES                    1
#define TST_READ_MAX_10_HANDLES          10
#define TST_HANDLE_ONE                   0
#define TST_HANDLE_TWO                   1
#define TST_HANDLE_THREE                 2
#define TST_HANDLE_FOUR                  3
#define TST_MAX_STRING_LENGTH            30
#define TST_MAX_ECC_KEY_SIZE_BYTES       256
#define NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES (1024000UL)
#define TST_BUFF1_SIZE_IN_BYTES          37
#define TST_BUFF2_SIZE_IN_BYTES          37

/*Addition:*/
/*---------*/
#define TST_NUM_OF_AES_KEYS  3
#define TST_NUM_OF_DES_KEYS  3
#define TST_NUM_OF_HMAC_KEYS 3
#define TST_NUM_OF_RSA_KEYS  2

/* Data types */
#define TST_DATA_OBJECT               0
#define TST_AESKEY_OBJECT            10
#define TST_DESKEY_OBJECT            20
#define TST_HMACKEY_OBJECT           30
#define TST_RSAKEY_OBJECT            40
#define TST_READ_ONLY_DATA_OBJECT    50
#define TST_MM_OBJECT                60



/* Strings */
#define TST_STRING_SIZE_8 8

/*Authenticator*/
#define TST_NO_CHALLENGE          0
#define TST_PASSWORD_STRING_LEN   1514
#define TST_N_SIZE_BYTES          256
#define TST_E_SIZE_BYTES          100
#define TST_D_SIZE_BYTES          256
#define TST_P_SIZE_BYTES          128
#define TST_Q_SIZE_BYTES          128
#define TST_DP_SIZE_BYTES         128
#define TST_DQ_SIZE_BYTES         128
#define TST_QINV_SIZE_BYTES       128
#define TST_CHALLENGE_SIZE_BYTES  256
#define TST_AES_KEY_SIZE          32
#define TST_HMAC_KEY_SIZE         400
#define TST_NO_OFFSET             0

/*Data*/
#define TST_MAX_DATA_VEC_SIZE_IN_BYTES   1536
#define TST_SMALL_BUFFER                 50
#define READ_DATA_FROM_START             0

/*AES*/
#define AES_KEY_128_SIZE_IN_BYTES 16
#define AES_KEY_192_SIZE_IN_BYTES 24
#define AES_KEY_256_SIZE_IN_BYTES 32
#define TST_AES_MAX_IV_SIZE_BYTES 16
#define TST_VECTOR_SIZE           16
#define TST_AES_KEY_TYPE               1
/*HMAC*/
#define TST_HMAC_4BYTE_KEY  4
#define TST_HMAC_32BYTE_KEY 32
#define TST_HMAC_65BYTE_KEY 65
#define MAX_HAMC_KEY_SIZE   TST_HMAC_65BYTE_KEY
#define TST_HMAC_KEY_TYPE   1

/*RSA*/
#define TST_PUB_EXPONENT_SIZE           3
#define TST_RSA_1024BIT_KEY             1024
#define TST_RSA_1024BIT_KEYSIZE_BYTES   128
#define TST_RSA_2048BIT_KEY             2048
#define TST_RSA_2048BIT_KEYSIZE_BYTES   256
#define TST_RSA_MAX_KEYSIZE_BYTES       256
#define TST_RSA_KEYPAIR_TYPE            1
#define TST_RSA_CRT_KEYPAIR_TYPE        2 
#define TST_RSA_OAEP_DATA_IN_SIZE       10 
/*DES*/
#define TST_DES_KEY_SIZE 24
#define TST_DES_KEY_TYPE 1


/*basic block size operation: round up \ down and reminder*/

#define TST_SST_BLOCK_REMINDER_SIZE(size) ((size) & (0xf))

#define TST_SST_BLOCK_ROUNDED_DOWN_SIZE(size)	((size) - (TST_SST_BLOCK_REMINDER_SIZE(size)))

#define TST_SST_BLOCK_ROUNDED_UP_SIZE(size)	 (TST_SST_BLOCK_REMINDER_SIZE(size)? \
                                             (TST_SST_BLOCK_ROUNDED_DOWN_SIZE(size)+ 16): \
                                             (size))

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/************************ Global Data ***************************/
extern DxError_t    TST_Error;

#ifdef __cplusplus
}
#endif

#endif

